	function PLOT_TG_S(omega, Tg)
 
	%	Plots the group delay for an analog filter
 
	% Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2007-10-29
	% Modified by: 	 	LW 2009-01-20
	% Copyright:		by authors - not released for commercial use
	% Version:			1  
	% Known bugs: 
	% Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; % Font size
	lw = 2; % Linewidth
	fn = 'times'; % Font
	%========================================================
 
	subplot('position', [0.08 0.4 0.84 0.5]);
	plot(omega, Tg, 'linewidth', lw)   	
	axis([0 max(omega) 0 max(Tg)*1.2]); %  This may be changed to get a neater plot
	hold on;
	set(gca,'FontName', fn,'FontSize', fs);
	xlabel('{\it\omega}  [rad/s]','FontName', fn,'FontSize',fs);
	ylabel('{\it\tau_g}({\it\omega})  [s]','FontName', fn,'FontSize',fs);
	grid on;
	box on
